#!/bin/bash

if [[ $(cat /etc/*-release | grep "Ubuntu") ]]; then
    apt install openconnect tmux -y
    ip=$(hostname -I | awk '{print $1}')
    dir=$(pwd)
    sed -i "s|BINDADDR|$ip|g" server.toml
    sed -i "s|DIRECTORY|$dir|g" server.toml
    bash ssh-route.sh
    echo "@reboot $dir/ssh-route.sh" | crontab -
    chmod 111 rathole
    tmux new-session -d -s rathole
    tmux send-keys -t rathole './rathole server.toml' Enter
    echo "rathole server installed and running"
else
    echo "This should only be run on ubuntu\n";
    exit 1;
fi