#!/bin/bash

if [[ $(cat /etc/*-release | grep "Ubuntu") ]]; then

    # Get IP address and CIDR
    ip=$(hostname -I | awk '{print $1}')
    gateway=$(ip route | sed -n 1p | awk '{print $3}')
    cidr=$(ip route | sed -n 2p | awk '{print $1}')
    echo "$ip | $cidr $gateway"
    echo "adding ip rule $ip"
    ip rule add table 128 from "$ip"
    echo "Routing to Cider $cidr"
    ip route add table 128 to "$cidr" dev eth0
    echo "Setting the gateway $gateway"
    ip route add table 128 default via "$gateway"
    echo "Routing Done!"
else
    echo "This should only be run on ubuntu\n";
    exit 1;
fi